<?php
/**
 * Bot Telegram Pribadi
 * Entry point untuk webhook Telegram
 */

// Load environment variables
require_once __DIR__ . '/../vendor/autoload.php';
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->load();

// Require files
require_once __DIR__ . '/functions.php';
require_once __DIR__ . '/commands.php';
require_once __DIR__ . '/keyboard.php';

// Database connection
$db = connectDB();

// Get updates from Telegram
$update = json_decode(file_get_contents('php://input'), true);
logBotActivity('bot_receive_update', json_encode($update));

// Handle update based on type
if (isset($update['message'])) {
    handleMessage($update['message'], $db);
} elseif (isset($update['callback_query'])) {
    handleCallbackQuery($update['callback_query'], $db);
} else {
    // Unknown update type
    logBotActivity('unknown_update_type', json_encode($update));
}

/**
 * Handle incoming message
 */
function handleMessage($message, $db)
{
    $chatId = $message['chat']['id'];
    $userId = $message['from']['id'];
    $text = $message['text'] ?? '';
    $firstName = $message['from']['first_name'] ?? '';
    $lastName = $message['from']['last_name'] ?? '';
    $username = $message['from']['username'] ?? '';
    
    // Check if user is blocked
    if (isUserBlocked($userId, $db)) {
        $message = "🚫 <b>ACCESS BLOCKED</b>\n";
    $message .= "═════════════════════════\n";
    $message .= "Your account cannot access this Bot.\n\n";
    $message .= "Possible reason:\n";
    $message .= "• Terms violation\n";
    $message .= "• Suspicious activity\n";
    $message .= "• Not complying with regulations\n\n";
    $message .= "ℹ️ To appeal, contact @rinda_escobar";
    
    sendMessage($chatId, $message);
        logBotActivity('blocked_user_attempt', $userId);
        return;
    }
    
    // Register user if not exist
    registerUser($userId, $username, $firstName, $lastName, $db);
    
    // Check if user sent a file
    if (isset($message['document'])) {
        // Only admin can upload files
        if ($userId == $_ENV['ADMIN_TELEGRAM_ID']) {
            handleFileUpload($message, $db);
        } else {
            $message = "📤 <b>Thank You for Your File</b>\n";
            $message .= "════════════════════════\n";
            $message .= "We have received your file, but:\n\n";
            $message .= "⛔ <b>Limited Uploads</b>\n";
            $message .= "Only admins can upload files.\n\n";
            $message .= "🔓 Want to become an administrator?\n";
            $message .= "Contact @rinda_escobar for special permission";

sendMessage($chatId, $message);
        }
        return;
    }
    
    // Di dalam fungsi handleMessage(), tambahkan ini sebelum bagian processCommand():
    // Handle image to base64 conversion
    if (isset($message['photo'])) {
        handleImageToBase64($message, $db);
        return;
    }
    
    // Process commands
    if (strpos($text, '/') === 0) {
        processCommand($text, $chatId, $userId, $db);
        return;
    }
    
    /*
    
    // Check if input is a key for member area
    if (strlen($text) == 16 && preg_match('/^[A-Za-z0-9]+$/', $text)) {
        processKeyActivation($text, $chatId, $userId, $db);
        return;
    }
    */
    
    $welcomeMessage = "✨ <b>WELCOME</b> ✨\n\n";
    $welcomeMessage .= "Welcome to RINDA'S Bot\n";
    $welcomeMessage .= "Please use menu below for navigation.\n";
    $welcomeMessage .= "═══════════════════════\n";
    $welcomeMessage .= "🆘 Type /help for help";
    
    sendMessage($chatId, $welcomeMessage, getMainKeyboard());
}

/**
 * Handle callback query (inline button clicks)
 */
function handleCallbackQuery($callbackQuery, $db)
{
    $chatId = $callbackQuery['message']['chat']['id'];
    $userId = $callbackQuery['from']['id'];
    $data = $callbackQuery['data'];
    $messageId = $callbackQuery['message']['message_id'];
    
    // Check if user is blocked
    if (isUserBlocked($userId, $db)) {
        answerCallbackQuery($callbackQuery['id'], "🚫 Sorry, your access has been blocked.");
        return;
    }
    
    // Process callback data
    $callback = explode(':', $data);
    $action = $callback[0];
    
    switch ($action) {
        case 'files':
            showFiles($chatId, $userId, $db, false);
            break;
           /* 
        case 'premium':
            if (hasAccessToMemberArea($userId, $db)) {
                showFiles($chatId, $userId, $db, true);
            } else {
                showMemberAreaInfo($chatId);
            }
            break;
            */
        case 'download':
            $fileId = $callback[1] ?? 0;
            processFileDownload($chatId, $userId, $fileId, $db);
            break;
            
        case 'help':
            showHelp($chatId);
            break;
            
        case 'categories':
            $isPremium = isset($callback[2]) ? (bool)$callback[2] : false;
            showCategories($chatId, $userId, $db, $isPremium);
            break;
            
        case 'category':
            $categoryId = $callback[1] ?? 0;
            $isPremium = isset($callback[2]) ? (bool)$callback[2] : false;
            showFiles($chatId, $userId, $db, $isPremium, $categoryId);
            break;
            
        case 'search':
          sendMessage($chatId, "🔍 Type /search followed by keyword you want to search for\nExample: /search lua script", getSearchKeyboard());
          break;
          
          case 'tools_menu':
    $message = "🛠 <b>TOOLS MENU</b>\n\n";
    $message .= "Select a tool to use:";
    editMessageText($chatId, $callbackQuery['message']['message_id'], $message, getToolsKeyboard());
    break;

case 'tool_image_to_base64':
    $message = "🖼 <b>IMAGE TO BASE64</b>\n\n";
    $message .= "To use this tool, simply send any image to this chat.\n";
    $message .= "The bot will convert it to Base64 and send you a text file.";
    editMessageText($chatId, $callbackQuery['message']['message_id'], $message, getBackKeyboard('tools_menu'));
    break;
         /* 
        case 'activate_key':
    $message = "🌟 <b>PREMIUM MEMBERSHIP ACTIVATION</b> 🌟\n";
    $message .= str_repeat("═", 27) . "\n";
    $message .= "🔐 <i>Unlock exclusive content with your activation key</i>\n\n";
    
    $message .= "📌 <b>HOW TO ACTIVATE:</b>\n";
    $message .= "1. Type <code>/activate YOUR_KEY</code>\n";
    $message .= "2. Press send button\n\n";
    
    $message .= "🖊️ <b>EXAMPLE:</b>\n";
    $message .= "<code>/activate ABCD-EFGH-IJKL-MNOP</code>\n\n";
    
    $message .= "ℹ️ <b>Key Requirements:</b>\n";
    $message .= "• 16 alphanumeric characters\n";
    $message .= "• No spaces or special characters\n";
    $message .= "• Case insensitive\n\n";
    
    $message .= "⚠️ <b>Troubleshooting:</b>\n";
    $message .= "• Double-check your key\n";
    $message .= "• Contact support if issues persist\n";
    $message .= "• One key per account only\n\n";
    
    $message .= "🔗 <i>Get your key from</i> @rinda_escobar";

    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '💎 GET PREMIUM KEY', 'url' => 'https://t.me/rinda_escobar'],
            ],
            [
                ['text' => '📚 ACTIVATION GUIDE', 'callback_data' => 'activation_guide'],
                ['text' => '🆘 SUPPORT', 'callback_data' => 'contact_support']
            ],
            [
                ['text' => '← BACK TO MENU', 'callback_data' => 'help']
            ]
        ]
    ];
    
    // Edit the original message instead of sending new one
    editMessageText($chatId, $callbackQuery['message']['message_id'], $message, $keyboard);
    answerCallbackQuery($callbackQuery['id'], "Premium activation instructions sent");
    break;
    
        case 'activation_guide':
    $message = "📘 <b>PREMIUM ACTIVATION GUIDE</b>\n";
    $message .= str_repeat("═", 27) . "\n";
    $message .= "1. Purchase your 16-digit key\n";
    $message .= "2. Type <code>/activate KEY</code>\n";
    $message .= "3. Follow the instructions\n";
    $message .= "4. Access premium content with /premium\n\n";
    $message .= "🔄 <b>Troubleshooting:</b>\n";
    $message .= "• Keys are one-time use\n";
    $message .= "• Wait 5 minutes if server busy\n";
    $message .= "• Contact @rinda_escobar for help";
    
    editMessageText($chatId, $callbackQuery['message']['message_id'], $message);
    break;

case 'contact_support':
    $message = "🆘 <b>PREMIUM SUPPORT</b>\n";
    $message .= str_repeat("═", 27) . "\n";
    $message .= "Contact @rinda_escobar for:\n";
    $message .= "• Key activation issues\n";
    $message .= "• Membership questions\n";
    $message .= "• Payment assistance\n\n";
    $message .= "⏳ <i>Response time: Usually within 24 hours</i>";
    
    editMessageText($chatId, $callbackQuery['message']['message_id'], $message);
    break;
    
    case 'premium_guide':
    $message = "📘 <b>PREMIUM MEMBER GUIDE</b> 📘\n";
    $message .= str_repeat("═", 27) . "\n";
    $message .= "✨ Welcome to RINDA'S Premium Membership! ✨\n\n";
    
    $message .= "🔑 <b>Your Membership Includes:</b>\n";
    $message .= "• Full access to premium content\n";
    $message .= "• Exclusive downloads and resources\n";
    $message .= "• Priority customer support\n";
    $message .= "• Special member-only features\n\n";
    
    $message .= "🚀 <b>Getting Started:</b>\n";
    $message .= "1. Use <code>/premium</code> to access member area\n";
    $message .= "2. Browse available content with /files\n";
    $message .= "3. Download resources with /download_[ID]\n";
    $message .= "4. Search content with /search [keyword]\n\n";
    
    $message .= "💎 <b>Premium Features:</b>\n";
    $message .= "• Higher download limits\n";
    $message .= "• Early access to new releases\n";
    $message .= "• VIP support channel access\n";
    $message .= "• Special member discounts\n\n";
    
    $message .= "🆘 <b>Need Help?</b>\n";
    $message .= "• Contact @rinda_escobar for support\n";
    $message .= "• Report issues immediately\n";
    $message .= "• Check /faq for common questions\n\n";
    
    $message .= "📅 <i>Last updated: " . date('d M Y') . "</i>";

    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '🚀 ENTER PREMIUM AREA', 'callback_data' => 'premium'],
            ],
            [
                ['text' => '❓ FAQ', 'callback_data' => 'premium_faq'],
                ['text' => '🆘 SUPPORT', 'url' => 'https://t.me/rinda_escobar']
            ],
            [
                ['text' => '🏠 MAIN MENU', 'callback_data' => 'help']
            ]
        ]
    ];

    editMessageText($chatId, $callbackQuery['message']['message_id'], $message, $keyboard);
    answerCallbackQuery($callbackQuery['id'], "Premium Member Guide loaded");
    break;
    
    case 'premium_faq':
    $message = "❓ <b>PREMIUM MEMBER FAQ</b> ❓\n";
    $message .= str_repeat("═", 27) . "\n";
    
    $message .= "<b>Q: How long does my membership last?</b>\n";
    $message .= "A: Your membership is valid for 30 days from activation.\n\n";
    
    $message .= "<b>Q: Can I share my account?</b>\n";
    $message .= "A: No, account sharing violates our terms of service.\n\n";
    
    $message .= "<b>Q: Where do I find downloadable content?</b>\n";
    $message .= "A: Use <code>/premium</code> then browse categories.\n\n";
    
    $message .= "<b>Q: What's my daily download limit?</b>\n";
    $message .= "A: Premium members get 20 downloads/day (3 for regular users).\n\n";
    
    $message .= "<b>Q: How do I renew my membership?</b>\n";
    $message .= "A: Contact @rinda_escobar before expiration date.\n\n";
    
    $message .= "<b>Q: Can I get a refund?</b>\n";
    $message .= "A: Refunds are only available for unused keys within 7 days.\n\n";
    
    $message .= "📌 <i>More questions? Contact @rinda_escobar</i>";

    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '📚 FULL GUIDE', 'callback_data' => 'premium_guide'],
                ['text' => '🆘 CONTACT SUPPORT', 'url' => 'https://t.me/rinda_escobar']
            ]
        ]
    ];

    editMessageText($chatId, $callbackQuery['message']['message_id'], $message, $keyboard);
    break;
*/
            
        default:
            sendMessage($chatId, "❌ Action not recognized.");
            break;
    }
    
    // Answer callback query to remove loading state
    answerCallbackQuery($callbackQuery['id']);
}

// Set webhook (for first time setup, you should access this via web browser)
if (isset($_GET['setwebhook'])) {
    $webhookUrl = $_ENV['BOT_URL'] . '/index.php';
    $result = setWebhook($webhookUrl);
    echo $result ? "Webhook set successfully" : "Failed to set webhook";
}
