<?php
/**
 * Authentication check for admin pages
 */

// Start session
session_start();

// Load environment variables
require_once __DIR__ . '/../vendor/autoload.php';
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->load();

// Check if logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: index.php');
    exit;
}

// Check session timeout (30 minutes)
$sessionTimeout = 1800; // 30 minutes
if (time() - $_SESSION['admin_last_activity'] > $sessionTimeout) {
    // Session expired, log out
    session_unset();
    session_destroy();
    header('Location: index.php?expired=1');
    exit;
}

// Update last activity time
$_SESSION['admin_last_activity'] = time();

// Connect to database
try {
    $db = new PDO(
        "mysql:host=" . $_ENV['DB_HOST'] . ";dbname=" . $_ENV['DB_NAME'] . ";charset=utf8mb4",
        $_ENV['DB_USER'],
        $_ENV['DB_PASS'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]
    );
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Check if session exists in database
try {
    $stmt = $db->prepare("SELECT id FROM admin_sessions WHERE session_id = ?");
    $stmt->execute([$_SESSION['admin_session_id'] ?? '']);
    
    if (!$stmt->fetch()) {
        // Invalid session, log out
        session_unset();
        session_destroy();
        header('Location: index.php?invalid=1');
        exit;
    }
} catch (PDOException $e) {
    // Log error but continue
    error_log("Session validation error: " . $e->getMessage());
}

// Logout handler
if (isset($_GET['logout'])) {
    // Remove session from database
    try {
        $stmt = $db->prepare("DELETE FROM admin_sessions WHERE session_id = ?");
        $stmt->execute([$_SESSION['admin_session_id'] ?? '']);
    } catch (PDOException $e) {
        // Just log error
        error_log("Logout error: " . $e->getMessage());
    }
    
    // Clear session
    session_unset();
    session_destroy();
    
    // Redirect to login
    header('Location: index.php?logout=1');
    exit;
}